Option Explicit
on error resume next

' ===============================
' NAME: FREESPACE.vbs V2.0
'
' AUTHOR: Brian Hanlon, The Baldy Aussie
' URL:
' DATE : 25/05/2010
' COPYWRONG (c) 2010 All Rites Reversed
'
' COMMENT: Reports Free Space, Total Space & free_space%
' for Local Drives, and System Totals.
'
' NOW WITH BARGRAPH!

' ================================
' Variables for the Drive Info section

DIM objWMIService, colDisks, objDisk
DIM intTotalSpace, intFreeSpace, subTotalSpace
DIM subTotalFree, pctFreeSpace, strPercent
DIM printDiskSize, printDiskFree, printFileSystem
DIM printVolumeName, printVolSerNum, printGTotalSize
DIM printGTotalFree, gPercent

' =================================
' Variables for the GetSize subroutine:

DIM KB, MB, GB, TB, PB, MX
DIM KD, MD, GD, TD, PD, PP
DIM sizeb, psize

' Set up Suffix values

KB = 1024 '''' 1,024 1 Kb
MB = KB * KB ' 1,048,576 1 Mb
GB = MB * KB ' 1,073,741,824 1 Gb
TB = GB * KB ' 1,099,511,627,776 1 Tb
PB = TB * KB ' 1,125,899,906,842,624 1 Pb
MX = 11253369568892021
' 11,253,369,568,892,021 9.99 Pb

' Set up rollover values such that at > 31/32 of
' next stage value, use next stage for display.
' 992 = 1024 * 31 / 32

KD = 992
MD = 992 * KB
GD = 992 * MB
TD = 992 * GB
PD = 992 * TB

'' Value Display - Value Display
'' 992 B '992 B '' 992 K '993 K
'' 993 B '.97 K '' 993 K '.97 M
' 1030 B 1.01 K ' 1030 K 1.01 M
' Thusly 1,000 B is avoided, keeping the display width down.
' ==================================
' Variables for output formatting

DIM sp11, sp10, sp9, sp5, sp4, sp1
DIM pline, pline1, pline2, pline3, pline4

sp11 = Space(11) '''''' sp"n" is an easy mnemonic for Space(n)
sp10 = Left(sp11,10) '' and takes less space in the body of
sp9 = Left(sp11,9) ''' this listing than using Space(n)
sp5 = Left(sp11,5) ''' and sp4 is faster than Space(4) !!!
sp4 = Left(sp11,4)
sp1 = Left(sp11,1)

' ==================================
' Variables for Low FreeSpace Warning
' and Bar Graph

Dim WarnMsg, WarnOff, WarnLow, WarnCritical, pctLow, pctCritical
WarnOff = sp10
WarnLow = " Low Space"
WarnCritical = " CRITICAL!" ' Note that these are ALL 10 Chars

pctLow = 0.10 '''''''''''''''''''''' LOW Threshold - AS DECIMAL
pctCritical = 0.05 '''''''''''' CRITICAL Threshold - AS DECIMAL

' ===================================
' Variables for output switching -
' BGINFO does NOT like wscript.echo
' but I want to test run with
' "cscript freespace.vbs //nologo"
' calling for WScript.Name
' gives Err.Number 500 under BGINFO
' but Err.Number = 0 if under cscript/wscript

DIM IsBginfo

IsBginfo = WScript.Name
IsBginfo = Err.Number

' ====================================
' Variables for BarGraph - BGINFO does NOT like UNICODE!
' So, use an old Font - MS LineDraw TTF
' But be SURE to set the font in BGINFO for the
' FREESPACE.VBS Custom Field or it will look weird!

Dim B000, B025, B050, B075, B100
Dim LD025, LD050, LD075
Dim StringBar, BarGraph, BarLength

BarLength = 60 '''''' Set to length of BarGraph required

' UNICODE Cha4racters which give a pretty result in cscript,
' but FAIL MISERABLY in BGINFO
''''''''''''''''''''''' Keystroke - UNICODE - CHARACTER
B000 = ChrW(0160) ''''' Alt+ 0160 - U+ 2588 - Empty Block
B025 = ChrW(9617) ''''' Alt+ 9617 - U+ 2591 - Light Shade
B050 = ChrW(9618) ''''' Alt+ 9618 - U+ 2592 - Medium Shade
B075 = ChrW(9619) ''''' Alt+ 9619 - U+ 2593 - Dark Shade
B100 = ChrW(9608) ''''' Alt+ 9608 - U+ 2588 - Full Block

' MSLineDraw.ttf characters - IF you have that Font!
LD025 = ChrB(176) '''''' Light Shade
LD050 = ChrB(177) '''''' Medium Shade
LD075 = ChrB(178) '''''' Dark Shade

' Middle Dot & Currency Sign
LD025 = ChrB(183) '''''' Middle Dot
LD075 = ChrB(164) '''''' Currency Sign

' Middle Dot & Equals Sign
LD025 = ChrB(183) '''''' Middle Dot
LD075 = ChrB(61) ''''''' Equals Sign

' Comment out and/or swap around the LDnnn entries to suit

If IsBgInfo > 0 then 
StringBar = String(60, LD075) & String(60, LD025)
else
StringBar = String(60, B075) & String(60, B025)
End If

' ====================================
' All Variables declared, now for the working bits:
' Although the DIM's above are not strictly required,
' They DO help while testing - using Option Explicit.

' =====================================
' Module to gather info for all Drives of Type 3
' (INCLUDES SUBST Drives!), so totals may be corrupt.

' Multiple-spaces do NOT survive the Forum Copy/Paste,
' So multiple-spaces have been replaced by concatenations.
'''''''''' That's also why some comments have lots of ''''
'''''''''' But I cannot preserve body layout -
'''''''''' Leading whitespace is stripped.

pline1 = " Drive " & " DrvFree Fr% " & " Drv_Cap " & sp9 _
& " FSYST Volume_Name _Serial#" & vbCRLF

OutPut(pline1)

Set objWMIService = GetObject("winmgmts:" _
& "{impersonationLevel=impersonate}!\\.\root\cimv2")
Set colDisks = objWMIService.ExecQuery _
("Select * from Win32_LogicalDisk Where DriveType = 3")

For Each objDisk in colDisks

intFreeSpace = 0 + objDisk.FreeSpace
intTotalSpace = 0 + objDisk.Size

subTotalFree = subTotalFree + intFreeSpace
subTotalSpace = subTotalSpace + intTotalSpace

pctFreeSpace = intFreeSpace / intTotalSpace
If (pctFreeSpace <= pctCritical) then
WarnMsg = WarnCritical
ElseIf (pctFreeSpace > pctCritical) AND (pctFreeSpace < pctLow) then
WarnMsg = WarnLow
Else WarnMsg = WarnOff
End If
strPercent = FormatPercent(pctFreeSpace,0,-1,0,0)
strPercent = Right((sp5 & strPercent),4)
BarGraph = sp5 & Mid(StringBar, (BarLength * pctFreeSpace), BarLength)
' & vbCRLF '''''' add the & vbCRLF for an extra linefeed

printDiskSize = GetSize(intTotalSpace)
printDiskSize = Left(sp9,(9-Len(printDiskSize))) _
& printDiskSize

printDiskFree = GetSize(intFreeSpace)
printDiskFree = Left(sp9,(9-Len(printDiskFree))) _
& printDiskFree

printFileSystem = sp1 & LEFT((objDisk.FileSystem & sp5),5)
printVolumeName = sp1 & LEFT((objDisk.VolumeName & sp11),11)
printVolSerNum = sp1 & objDisk.VolumeSerialNumber

pline1 = sp4 & objDisk.Name & printDiskFree & strPercent _
& printDiskSize & WarnMsg & printFileSystem _
& printVolumeName & printVolSerNum

OutPut(pline1)
Output(BarGraph)
Next

' ======================================
' TOTALS

printGTotalFree = GetSize(subTotalFree)
printGTotalFree = Left(sp9,(9-Len(printGTotalFree))) _
& printGTotalFree

printGTotalSize = GetSize(subTotalSpace)
printGTotalSize = Left(sp9,(9-Len(printGTotalSize))) _
& printGTotalSize

gPercent = subTotalFree / subTotalSpace
gPercent = FormatPercent(gPercent,0,-1,0,0)
gPercent = Right((sp5 & gPercent),4)
BarGraph = sp5 & Mid(StringBar, (BarLength * gPercent), BarLength)
' & vbCRLF '''''' add the & vbCRLF for an extra linefeed

pline1 = "----- ========= === ========"
pline2 = "TOTAL:" & printGTotalFree & gPercent _
& printGTotalSize

OutPut(pline1)
OutPut(pline2)
OutPut(pline1)
Output(BarGraph)

' All over!

' WSCript.Quit just to mark the spot where we exit

' =======================================
' function to format the numbers in a readable fashion

function GetSize(sizeb)

PP = (-10000000 * (sizeb > MX)) _
   + ( -1000000 * (sizeb > PD)) _
    + ( -100000 * (sizeb > TD)) _
     + ( -10000 * (sizeb > GD)) _
      + ( -1000 * (sizeb > MD)) _
       + ( -100 * (sizeb > KD)) _
        + ( -10 * (sizeb > 0)) _
         + ( -1 * (sizeb <= 0))

Select Case Len(PP)
Case "1" psize = "------ !" ' < 1
Case "2" psize = FormatNumber(sizeb,0,0,0,-1) & " B"
Case "3" psize = FormatNumber((sizeb / KB),2,0,0,-1) & " K"
Case "4" psize = FormatNumber((sizeb / MB),2,0,0,-1) & " M"
Case "5" psize = FormatNumber((sizeb / GB),2,0,0,-1) & " G"
Case "6" psize = FormatNumber((sizeb / TB),2,0,0,-1) & " T"
Case "7" psize = FormatNumber((sizeb / PB),2,0,0,-1) & " P"
Case Else psize = "****** ?"
End Select

GetSize = psize

end function

' The logic above sets PP as 0's & 1's positionally indicating
' whether sizeb is greater than a list of decreasing values.
' Thus the range of sizeb is indicated by the length of "PP"
' Math logic is used, as it is faster than string logic.
'
' XPTGMKBZ
' 10000000 if > MX Len=8
'' 1000000 if > PD Len=7
''' 100000 if > TD Len=6
'''' 10000 if > GD Len=5
''''' 1000 if > MD Len=4
'''''' 100 if > KD Len=3
''''''' 10 if > B Len=2
'''''''' 1 if < 0 Len=1
'
' FormatNumber(Number,Dig,Lead,Parnth,Group)
' FormatNumber(Expression,NumDigAfterDec,
' IncLeadingDig, UseParenthForNegNum, GroupDig)
' -2=Use System Default, -1=USE OPTION, 0=NOT USE OPTION

' ========================================
' Subroutine to control output
' BgInfo does NOT handle Wscript.Echo, so we fudge it:

Sub OutPut(pline)

If IsBgInfo > 0 then
echo pline '''''''''' if Called by BgInfo use Echo
else
WScript.echo pline '' else use WScript.Echo
End If

End Sub